function hide(id) {
    document.getElementById(id).style.display = "none"
}
function show(id) {
    document.getElementById(id).style.display = "inline"
}

function roundw(i,t) {
    return Math.round(i * Math.pow(10,t)) / Math.pow(10,t)
}

function parse_size(i) {
    if (i > 2000000000) {
        return (roundw(i/1000000000,2)) + " GB"
    }
    if (i > 2000000) {
        return roundw(i/1000000,2) + " MB"
    }
    if (i > 2000) {
        return roundw(i/1000) + " KB"
    } else {
        return i + " bytes"
    }
}

function startProgress() {
    document.getElementById("progress").hidden = false
    document.getElementById("loadinganimation").hidden = false
}

function endProgress() {
    document.getElementById("progress").hidden = true
    document.getElementById("loadinganimation").hidden = true
}

function b2i(v) {
    if (v) {
        return 1
    } else {
        return 0
    }
}

function get_where(object,field,search) {
    //Returns first item of object where field = search
    var result;
    object.forEach(element => {
        //console.log(element[field]+" "+search+" = "+(element[field] == search).toString())
        if (element[field] == search) {
            result = element;
        }
    });
    return result;
    
}

function resetFields() {
    var elements = document.querySelectorAll("input,textarea");
    addedMapPoints = Array() //Reset map points
    for (var ii = 0; ii < elements.length; ii++) {
        if (elements[ii].type == "text") {
            elements[ii].value = "";
        }
        if (elements[ii].type == "number") {
            elements[ii].value = 1;
        }
        if (elements[ii].type == "textarea") {
            elements[ii].value = "";
        }
        if (elements[ii].type == "date") {
            elements[ii].value = "";
        }
    }
}

function doCopyOf(text) {
    navigator.clipboard.writeText(text)
}

function dict_has(haystack, needle) {
    return haystack[needle] !== undefined
}

function get_childrens_id(parent) {
    //This is a suspicious name...
    var ids = [];
    var children = document.getElementById(parent).children; //get container element children.
    for (var i = 0, len = children.length; i < len; i++) {
        ids.push(children[i].id); //get child id.
    }
    return ids;

}

function isHidden(el) {
    return (el.offsetParent === null)
}

function openModal(id) {
    document.getElementById(id).hidden = false
}
function closeModal(id) {
    document.getElementById(id).hidden = true
    resetFields()
}

function select_get_selected_option(id) {
    let so = document.getElementById(id)
    return so.options[so.selectedIndex].value
}

function createTableCellWithObject(ob) {
    let c = document.createElement("td")
    c.appendChild(ob)
    return c
}

function createTableCellWithText(tx) {
    let c = document.createElement("td")
    c.innerHTML = tx
    return c
}

function parseBool(i) {
    return (i == 1)
}

function getIndexOfFromArrayBasedOnKey(ar, k, v) {
    //Returns of index of ar for which ar[n].k = v
    let ti = 0
    let lti = null;
    ar.forEach(element => {
        if (element[k] == v) {
            lti = structuredClone(ti)

        }
        ti += 1
    });
    return lti;

}

function randomIntFromInterval(min, max) { // min and max included 
    return Math.floor(Math.random() * (max - min + 1) + min);
}

function bool2string(b) {
    if (b) {
        return "Yes"
    } else {
        return "No"
    }
}

function forceInt(i) {
    if (i === false) {
        return 0
    }
    if (i === true) {
        return 1
    }
    return i
}

function rg16() {
    let vals = [..."abcdefghijklmnopqrstuvwxyz1234567890"]
    let final = ""
    for (let i = 0;i<16;i++) {
        final += vals[randomIntFromInterval(0,vals.length-1)]
    }
    return final
}

function youtube_parser(url){
    var regExp = /^.*((youtu.be\/)|(v\/)|(\/u\/\w\/)|(embed\/)|(watch\?))\??v?=?([^#&?]*).*/;
    var match = url.match(regExp);
    return (match&&match[7].length==11)? match[7] : false;
}

function sync_files() {
    var apipath = window.location.pathname.replace("index.html","")+"/api/sync-files.php"
    fetch(apipath)
}

function fscall(action,variables,callback) {
    variables["_action"] = action
    try {
        variables["_username"] = username
        variables["_password"] = password
    } catch {
        
    }
    
    let rawvars = JSON.stringify(variables)
    //alert(rawvars)
    fetch(apipath.replace('api.php','fsinfo.php'), {
        method: 'POST',
        headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json'
        },
        body: rawvars
    }).then(
        function(r) {
            let _s = r.status
            r.text().then(function(t) {
                t = t.replaceAll("#SQ","'").replaceAll("#DQ",'\\"')
                console.log(`${action} [${rawvars}] -> ${t} (${_s})`)
                //alert(t)
                callback(new APIResponse(t,_s))
            })
        }
    )
}