function round22(v) {
    return Math.round(v*100)/100
}

function parseSize(v) {
    if (v > 2000000000) {
        return Math.floor(round22(v/1000000000)) + " GB"
    }
    if (v > 2000000) {
        return Math.floor(round22(v/1000000)) + " MB"
    }
    if (v > 2000) {
        return Math.floor(round22(v/1000)) + " KB"
    }
    else {
        return v + " B"
    }
}

function uploadProgressCallback(ev) {
    let ld = ev.loaded
    let tt = ev.total
    document.getElementById("uploaddone").innerText = parseSize(tup+ld)
    document.getElementById("blockprogress").value = Math.round((ld/tt)*100)
    document.getElementById("uploadpercent").innerText = Math.round(((tup+ld)/totalen)*100)
    

}

function toBase64(dataArr){
    return btoa(dataArr.reduce((data, val)=> {
         return data + String.fromCharCode(val);
    }, ''));
}

function uploadBlock(blockno) {
    //document.getElementById("uploadblock").innerText = blockno + 1

    document.getElementById("uploadprogress").value = blockno
    document.getElementById("uploadtotal").innerText = parseSize(totalen)
    
    payload = fileblocks[blockno]
    if (payload == null || payload == undefined) {
        fetch(window.location.pathname.replace("index.html","")+"/api/uploader.php",{
            method: 'POST',
        headers: {
        'Accept': 'application/json',
        'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            _username:username,
            _password:password,
            token:token,
            fileid:fileid,
            action:"finish"
        })
        })
        closeModal('uploadprogressbox')
        closeModal('uploadbox')
        refreshPage()
        alert("Sucessfully uploaded file")
    } else {
        let rq = new XMLHttpRequest()
        //rq.onprogress = uploadProgressCallback
        rq.upload.addEventListener('progress',uploadProgressCallback,true)
        rq.open('POST',window.location.pathname.replace("index.html","")+"/api/uploader.php",true)
        //rq.setRequestHeader("Content-Type","multipart/form-data")
        //rq.setRequestHeader("Content-length",payload.length)
        rq.onreadystatechange = function() {
            if (rq.readyState == 4) {
                tup += settings.chunksize
                uploadBlock(structuredClone(blockno)+1)
            }
        }
        rq.send(payload)
    }
}

var fileblocks = Array()
var fileid;
var token;
var totalen;
var tup = 0;
//alert("Running nv3")
async function uploadFile2(file,filedata) {
    //console.log(filedata)
    let forid = document.getElementById("uploadforwhat").value;//Get selected ID value
    let fsize = file.size
    let fname = file.name
    
    let selected_object = get_where(uAssignmentData,"id",forid)
    let dd = new Date(selected_object.duedate)
    if (new Date(Date.now()) > dd && !selected_object.allowlate) {
        alert("This assignment has passed its due date")
        return
    }

    let chunks = Math.ceil(fsize/settings.chunksize)
    let fileext = fname.split('.')[fname.split('.').length - 1]

    openModal('uploadprogressbox')
    //document.getElementById("uploadtotalblock").innerText = chunks
    document.getElementById("uploadprogress").max = chunks

    let arraypos = 0
    let cn = 0
    
    //Send file creqte request
    let crq = await fetch(window.location.pathname.replace("index.html","")+"/api/uploader.php",{
        method: 'POST',
    headers: {
    'Accept': 'application/json',
    'Content-Type': 'application/json'
    },
    body: JSON.stringify({
        _username:username,
        _password:password,
        forid:forid,
        ext:fileext,
        action:"create",
        description:document.getElementById("uploaddesc").value
    })
    })
//alert("ns2")
    let crqb = JSON.parse(await crq.text())
    fileblocks = Array()
    fileid = crqb.data.fileid
    token = crqb.data.token
    totalen = fsize
    tup = 0//Fix bug where uploading another file in a session resulted in progress going way too high
    //alert("test")
    while (arraypos <= fsize) {
        
        let data;
        if ((fsize - arraypos) > settings.chunksize) {
            data = filedata.slice(arraypos,arraypos+settings.chunksize)
        } else {
            data = filedata.slice(arraypos)
        }

        /*let payload = JSON.stringify({
            data:toBase64(data),
            token:token,
            fileid:fileid,
            ext:fileext,
            action:"upload",
            _username:username,//CHANGE LATER!!
            _password:password
        })*/
        //alert("test")
        let payload = new FormData(document.getElementById('emptyform'));
        
        payload.append("token",token)
        payload.append("fileid",fileid)
        payload.append("ext",fileext)
        payload.append("action","upload")
        payload.append("_username",username)
        payload.append("_password",password)
        payload.append("data",new Blob([data],{ type: 'application/octet-stream'}))

        fileblocks.push(payload)//Not today, stupid JS scope

        //alert("pupload")
        arraypos += settings.chunksize
        cn += 1
    }
    //Start upload
    uploadBlock(0)
    
}

async function uploadFile() {
    let filee = document.getElementById("uploadfile")
    try {
        let file = filee.files[0]

        let reader = new FileReader()
        reader.onload = function() {
            uploadFile2(file,new Uint8Array(reader.result))
        }
        reader.readAsArrayBuffer(file)


    } catch {
        alert("Choose a file to upload.")
    }
    
}

var uAssignmentData = Array()

function openUpload() {
    call("get-assignments",{},function(r) {
        document.getElementById("uploadforwhat").innerHTML = ""
        uAssignmentData = Array()
        r.data.forEach(element => {
            //uAssignmentData.push(element)
            if (element.isactive) {
                uAssignmentData.push(element)
                let op = document.createElement("option")
                op.value = forceInt(element.id)
                op.innerText = element.name
                document.getElementById("uploadforwhat").appendChild(op)
            }
        });
        openModal("uploadbox")
        document.getElementById('uploadsubbox').hidden = true
        document.getElementById('ytsubbox').hidden = true
        document.getElementById('urlsubbox').hidden = true
    })
    
}

function isValidHttpUrl(string) {
    let url;
    
    try {
      url = new URL(string);
    } catch (_) {
      return false;  
    }
  
    return url.protocol === "http:" || url.protocol === "https:";
}

function uploadURL() {
    let url = document.getElementById("urlsub").value
    let desc = document.getElementById("uploaddesc2").value
    if (!isValidHttpUrl(url)) {
        alert("Invalid URL.")
        return
    }
    let forid = document.getElementById("uploadforwhat").value;//Get selected ID value
    
    let selected_object = get_where(uAssignmentData,"id",forid)
    let dd = new Date(selected_object.duedate)
    if (new Date(Date.now()) > dd && !selected_object.allowlate) {
        alert("This assignment has passed its due date")
        return
    }
    //TODO - Implement url and YT fully, 
    call('submit-for',{
        link:url,
        description:desc,
        assig:forid,
        special:"U"+rg16(),
        forwho:username
    },function(r) {
        alert("Submitted Successfully")
        closeModal('uploadbox')
        refreshPage()
    })

}

function uploadYT() {
    let url = document.getElementById("ytsub").value
    let desc = document.getElementById("uploaddesc3").value
    if (!isValidHttpUrl(url) || !url.includes('youtu')) {
        alert("Not a youtube video URL.")
        return
    }
    let forid = document.getElementById("uploadforwhat").value;//Get selected ID value
    
    let selected_object = get_where(uAssignmentData,"id",forid)
    let dd = new Date(selected_object.duedate)
    if (new Date(Date.now()) > dd && !selected_object.allowlate) {
        alert("This assignment has passed its due date")
        return
    }
    call('submit-for',{
        link:url,
        description:desc,
        assig:forid,
        special:"Y"+rg16(),
        forwho:username
    },function(r) {
        alert("Submitted Successfully")
        closeModal('uploadbox')
        refreshPage()
    })
}