//Table helper

//table id (body id, not root) {SQLNAME -> friendlyname}
var tablecolset = {
    assignmenttable : {
        name: "Name",
        duedate: "Due Date",
        filecount: "Submitted Files"
    },
    accounttable : {
        username: "Username",
        createdate: "Account Creation Date",
        logindate: "Last Login",
        privilege: "Account Privilege",
        realname: "Real Name"
    }
}

function generateSqlSuffix(rootid) {
    let bodyid = rootid;
    let tablerootid = rootid+"root"
    let ascid = rootid+"asc"
    let sbname = rootid+"sb"
    let descid = rootid+"desc"
    let selid = rootid+"sel"

    let final = "order by "
    final += document.getElementById(selid).value
    final += " "
    
    let ic = document.getElementById(ascid).checked
    if (ic) {
        final += "ASC"
    } else {
        final +=  "DESC"
    }
    return final
}

function initnewtable(rootid,refreshlink) {
    let bodyid = rootid;
    let tablerootid = rootid+"root"
    let ascid = rootid+"asc"
    let sbname = rootid+"sb"
    let descid = rootid+"desc"
    let selid = rootid+"sel"
    let rootobject = document.getElementById(tablerootid)
    let master = document.createElement("span")

    //S0 - find items
    let selectors = tablecolset[bodyid]

        //S2 - sort button
    
    let pobj = document.createElement("p")
    pobj.style.display = "inline"
    pobj.innerText = "Sort by "
    master.appendChild(pobj)

    //S1 - select
    let selobj = document.createElement("select")
    selobj.id = selid
    for (const [k,v] of Object.entries(selectors)) {
        let opobj = document.createElement("option")
        opobj.value = k
        opobj.innerText = v
        selobj.appendChild(opobj)
    }
    selobj.onchange = refreshlink
    master.appendChild(selobj)



    //S3 - label-radio pair
    let lobj;
    let robj;

    lobj = document.createElement("label")
    lobj.htmlFor = ascid
    lobj.innerText = "   Ascending"
    robj = document.createElement("input")
    robj.type = "radio"
    robj.id = ascid
    robj.name = sbname
    robj.checked = true
    robj.onclick = refreshlink
    master.appendChild(lobj)
    master.appendChild(robj)

    lobj = document.createElement("label")
    lobj.htmlFor = descid
    lobj.innerText = "Descending"
    robj = document.createElement("input")
    robj.type = "radio"
    robj.id = descid
    robj.name = sbname
    robj.onclick = refreshlink
    master.appendChild(lobj)
    master.appendChild(robj)

    rootobject.insertBefore(master,rootobject.firstChild)

}