function refreshFsPage() {
    fscall('getinfo',{},function(r) {
        document.getElementById("fstotal").innerHTML = parse_size(r.data.total)
        document.getElementById("fsused").innerHTML = parse_size(r.data.used)
        document.getElementById("fsfree").innerHTML = parse_size(r.data.free)
        document.getElementById("fsperc").innerHTML = Math.round(r.data.used / r.data.total * 100) + "% used"
        document.getElementById("fsusage").max = r.data.total
        document.getElementById("fsusage").value = r.data.used
    })
    fscall('fileinfo',{},function(r) {
        document.getElementById("fsfilesize").innerHTML = parse_size(r.data.size)
        document.getElementById("fsfilecount").innerHTML = r.data.count
    })
}

function deletetopn() {
    let todel = document.getElementById("delcount").value
    if (confirm("Are you sure you want to delete "+todel+" files?")) {
        call('delete-top-n',{n:todel},function(r){sync_files();refreshFsPage()})
    }
}

function deleteold() {
    let dtd = document.getElementById("deldate").value
    if (confirm("Are you sure you want to delete all uploads older than "+dtd+"?")) {
        call('delete-older',{date:dtd},function(r){sync_files();refreshFsPage()})
    }
}

function deleteall() {
    if (confirm("Are you sure you want to delete every file?")) {
        if (confirm("DANGER! THIS WILL DESTROY ALL SUBMISSION RECORDS EVER CREATED! ARE YOU SURE YOU WANT TO CONTINUE?")) {
            if (confirm("Last chance! You have been warned. Sure you want to proceed?")) {
                call('delete-all',{},function(r){sync_files();refreshFsPage()})
            }
        }
    }
}

function deleteseen() {
    if (confirm("Are you sure you want to delete all files you have marked as SEEN?")) {
        if (confirm("This action has the potential to delete a lot of files! Are you sure you want to continue?")) {
            call('delete-seen',{},function(r){sync_files();refreshFsPage()})
        }
    }
}


function refreshSettingsPage() {
    //Use settings
    document.getElementById("schoolname").value = settings.provider
    document.getElementById("cb1").checked = settings.allowaccountcreation
    document.getElementById("cb2").checked = settings.allownamechanges
    document.getElementById("cb3").checked = settings.allowaccountdeletion
    document.getElementById("ccsize").value = settings.chunksize
}

function bts(b) {
    if (b) {
        return "yes"
    } else {
        return "no"
    }
}

function savesettings() {
    let provider = document.getElementById("schoolname").value
    let aac = bts(document.getElementById("cb1").checked)
    let anc = bts(document.getElementById("cb2").checked )
    let aad = bts(document.getElementById("cb3").checked)
    let cs = document.getElementById("ccsize").value
    call('update-settings',{provider:provider,aac:aac,anc:anc,aad:aad,cs:cs},function(r){document.location.reload()})
}