<?php

#ini_set('display_startup_errors', 1);
#ini_set('display_errors', 1);
#error_reporting(-1);

function exception_error_handler(int $errno, string $errstr, string $errfile = null, int $errline)
{
    if (!(error_reporting() & $errno)) {
        // This error code is not included in error_reporting
        return;
    }
    throw new \ErrorException($errstr, 0, $errno, $errfile, $errline);
}
set_error_handler(exception_error_handler(...));
function error($errornumber, $errormessage)
{
    http_response_code($errornumber);
    $final = array();
    $final['message'] = $errormessage;
    echo json_encode($final);
    exit(1);
}

function senddata($data)
{
    http_response_code(200);
    $final = array();
    $final['data'] = $data;// Keep it safe for bool vs object list responses
    echo json_encode($final);
    exit(0);
}

function run_non_query($qs)
{
    //echo $qs;
    //Returns a bool, true if success
    global $sql_loc;
    global $sql_db;
    global $sql_user;
    global $sql_password;

    $c = new mysqli(
        $sql_loc,
        $sql_user,
        $sql_password,
        $sql_db
    );
    //$c->connect();
    $c->query($qs);
    $c->close();
    return true;
}

function encode_for_sql($input)
{
    $input = str_replace("'", "#SQ", $input);
    $input = str_replace("\"", "#DQ", $input);
    $input = str_replace(";", "#SC", $input);
    $input = str_replace(")", "#CB", $input);
    $input = str_replace("\n", "#NL", $input);
    $input = str_replace("\r", "#CR", $input);
    return $input;
}

function decode_for_sql($input)
{
    $input = str_replace("#SQ", "'", $input);
    $input = str_replace("#DQ", "\"", $input);
    $input = str_replace("#SC", ";", $input);
    $input = str_replace("#CB", ")", $input);
    $input = str_replace("#NL", "\n", $input);
    $input = str_replace("#CR", "\r", $input);
    return $input;
}

function tvconv($iv)
{
    if ($iv == "1") {
        return true;
    } elseif ($iv == "0") {
        return false;
    }
    if (is_numeric($iv)) {
        if (str_contains($iv, ".")) {
            return (float) $iv;
        }
        return (int) $iv;
    } else {
        return $iv;
    }
}

function run_query($qs)
{
    //echo $qs;
    //Returns list of dicts or null if error.
    global $sql_loc;
    global $sql_db;
    global $sql_user;
    global $sql_password;

    $c = new mysqli(
        $sql_loc,
        $sql_user,
        $sql_password,
        $sql_db
    );
    //$c->connect();

    $result = $c->query($qs);
    $final = array();
    if (is_bool($result)) {
        return array();
    }
    if ($result->num_rows > 0) {
        // output data of each row
        while ($row = $result->fetch_assoc()) {
            //array_push($final,$row);
            $t = array();
            foreach ($row as $key => $value) {
                $nv = tvconv($value);
                //echo $key . " : " . $nv. " : " . gettype($nv) . "\n";
                //For some reason, it isn't preserving the types
                $t[$key] = $nv;
            }
            array_push($final, $t);
        }
    } else {
        $final = array();
    }

    $c->close();
    return $final;

}

function run_query_p($query)
{
    $final = array();
    foreach ($query as $st) {
        //echo $st;
        $final = array_merge($final, run_query($st));
    }
    return $final;
}

function run_non_query_p($query)
{
    $iserror = false;
    foreach ($query as $st) {

        if (!run_non_query($st)) {
            $iserror = true;
            break;
        }
    }
    return $iserror;
}

function genran($len)
{
    $vals = str_split("1234567890qwertyuiopasdfghjklzxcvbnm");
    $final = "";
    for ($i = 0; $i < $len; $i++) {
        $cs = $vals[rand(0, count($vals) - 1)];
        $final = $final . $cs;
    }
    return $final;
}

function parse_raw_http_request(array &$a_data)
{
    // read incoming data
    $input = file_get_contents('php://input');

    // grab multipart boundary from content type header
    preg_match('/boundary=(.*)$/', $_SERVER['CONTENT_TYPE'], $matches);
    $boundary = $matches[1];

    // split content by boundary and get rid of last -- element
    $a_blocks = preg_split("/-+$boundary/", $input);
    array_pop($a_blocks);

    // loop data blocks
    foreach ($a_blocks as $id => $block) {
        if (empty($block))
            continue;

        // you'll have to var_dump $block to understand this and maybe replace \n or \r with a visibile char

        // parse uploaded files
        if (strpos($block, 'application/octet-stream') !== FALSE) {
            // match "name", then everything after "stream" (optional) except for prepending newlines 
            preg_match('/name=\"([^\"]*)\".*stream[\n|\r]+([^\n\r].*)?$/s', $block, $matches);
        }
        // parse all other fields
        else {
            // match "name" and optional value in between newline sequences
            preg_match('/name=\"([^\"]*)\"[\n|\r]+([^\n\r].*)?\r$/s', $block, $matches);
        }
        $a_data[$matches[1]] = $matches[2];
    }
}

function strict_search($needle,$haystack) {
    foreach ($haystack as $key) {
        # code...
        if (str_contains($needle,$key)) {
            return true;
        }
    }
    return false;
}

header("content-type: application/json");
$forbidden_extensions = explode(", .", "php, .php2, .php3, .php4, .php5, .php6, .php7, .phps, .phps, .pht, .phtm, .phtml, .pgif, .shtml, .htaccess, .phar, .inc, .hphp, .ctp, .module, .asp, .aspx, .config, .ashx, .asmx, .aspq, .axd, .cshtm, .cshtml, .rem, .soap, .vbhtm, .vbhtml, .asa, .cer, .shtml, .jsp, .jspx, .jsw, .jsv, .jspf, .wss, .do, .action, .js, .html, .htm, .html5, .py, .cfm, .cfml, .cfc, .dbm, .pl, .cgi");
        //Thank you polish hacking site for this list

try {
    $fd = json_decode(file_get_contents("db.json"), true);

    $sql_loc = $fd['location'];
    $sql_db = $fd['dbname'];
    $sql_user = $fd['sqluser'];
    $sql_password = $fd['sqlpass'];
    $sql_port = $fd['port'];

    try {
        $body = json_decode(file_get_contents('php://input'), true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Error();
        }
    } catch (Error) {
        //$body = array();
        //parse_raw_http_request($body);
        //var_dump($_POST);
        //var_dump($_FILES);
        $body = $_POST;
        
        $token = encode_for_sql($body["token"]);
        $fn = encode_for_sql($body["fileid"]);
        #$data = base64_decode($body["data"]);
        #$data = rawurldecode($body["data"]);
        #$data = $body["data"];
        $data = $_FILES['data']['tmp_name'];
        $tid = time();
        move_uploaded_file($data, "../files/temp/".$tid);
        $ext = encode_for_sql($body["ext"]);

        $is_valid_token = count(run_query("select * from filetokens where data = '$token' and filename = '$fn'")) > 0;
        if (!$is_valid_token) {
            error(403, "Invalid file token");
        }
        $dl = filesize("../files/temp/".$tid);
        run_non_query("update files set size = size + $dl where fileid = '$fn'");
        $rd = file_get_contents("../files/temp/".$tid);
        file_put_contents("../files/$fn.$ext", $rd, FILE_APPEND);
        unlink("../files/temp/".$tid);
        senddata("");
    }

    $action = $body["action"];

    $username = encode_for_sql($body["_username"]);
    $password = $body["_password"];
    $is_valid_password = count(run_query("select * from accounts where username = '" . encode_for_sql($username) . "' and password = SHA2('" . encode_for_sql($password) . "',256) and isactive = true")) > 0;
    if (!$is_valid_password) {
        error(401, "Invalid account");
    }

    run_non_query("delete from filetokens where created < NOW() - interval 1 day");//Clear old file tokens
    run_non_query("delete from files where iscomplete = false and created < NOW() - interval 1 day");

    if ($action == "create") {
        /*
        Generate new random name (including assignmentid)

        Receive - forid, name
        Create empty file
        Give user back a token
        */
        
        $token = genran(32);

        $ext = encode_for_sql($body["ext"]);

        if (strict_search(strtolower($ext), $forbidden_extensions)) {
            error(405, "Damn you, hacker!!");
        }

        $forx = encode_for_sql($body["forid"]);
        $desc = encode_for_sql($body["description"]);

        $fileid = genran(16);
        $filename = $fileid . "." . $ext;

        run_non_query("insert into files values ('$username',$forx,'$fileid','$filename',0,NOW(),0,'$desc',false)");
        run_non_query("insert into filetokens values ('$fileid','$token',NOW())");

        $file = fopen("../files/$filename", "x");
        fclose($file);

        senddata(array("fileid" => $fileid, "token" => $token));
    } else if ($action == "finish") {
        /*
        Delete the user's token. File upload is complete.
        */
        $token = encode_for_sql($body["token"]);
        $fn = encode_for_sql($body["fileid"]);
        run_non_query("delete from filetokens where data = '$token'");
        run_non_query("update files set iscomplete = true where fileid = '$fn'");
        senddata("");
    } else if ($action == "upload") {
        $token = encode_for_sql($body["token"]);
        $fn = encode_for_sql($body["fileid"]);
        $data = base64_decode($body["data"]);
        $data = rawurldecode($body["data"]);
        $ext = encode_for_sql($body["ext"]);

        $is_valid_token = count(run_query("select * from filetokens where data = '$token' and filename = '$fn'")) > 0;
        if (!$is_valid_token) {
            error(403, "Invalid file token");
        }
        run_non_query("update files set size = size + $dl where fileid = '$fn'");
        file_put_contents("../files/$fn.$ext", $data, FILE_APPEND);
        senddata("");
    } else if ($action == "abort") {
        //Used to abort an upload at user request
        $token = encode_for_sql($body["token"]);
        $fn = encode_for_sql($body["fileid"]);

        $ext = encode_for_sql($body["ext"]);

        $is_valid_token = count(run_query("select * from filetokens where data = '$token' and filename = '$fn'")) > 0;
        if (!$is_valid_token) {
            error(403, "Invalid file token");
        }
        $dl = strlen($data);
        run_non_query("delete from files where fileid = '$fn'");
        run_non_query("delete from filetokens where data = '$token'");
        unlink("../files/$fn.$ext");
        senddata("");
    }

} catch (Exception $e) {
    error(500, $e->getMessage() . "\n" . $e->getTraceAsString());
    exit(1);
}