<?php

#ini_set('display_startup_errors', 1);
#ini_set('display_errors', 1);
#error_reporting(-1);

function exception_error_handler(int $errno, string $errstr, string $errfile = null, int $errline) {
    if (!(error_reporting() & $errno)) {
        // This error code is not included in error_reporting
        return;
    }
    throw new \ErrorException($errstr, 0, $errno, $errfile, $errline);
}
set_error_handler(exception_error_handler(...));
function error($errornumber,$errormessage) {
    http_response_code($errornumber);
    $final = array();
    $final['message'] = $errormessage;
    echo json_encode($final);
    exit(1);
}

function senddata($data) {
    http_response_code(200);
    $final = array();
    $final['data'] = $data;// Keep it safe for bool vs object list responses
    echo json_encode($final);
    exit(0);
}

function run_non_query($qs) {
    //echo $qs;
    //Returns a bool, true if success
    global $sql_loc;
    global $sql_db;
    global $sql_user;
    global $sql_password;

    $c = new mysqli(
        $sql_loc,
        $sql_user,
        $sql_password,
        $sql_db
    );
    //$c->connect();
    $c->query($qs);
    $c->close();
    return true;
}

function encode_for_sql($input) {
    $input = str_replace("'","#SQ",$input);
    $input = str_replace("\"","#DQ",$input);
    $input = str_replace(";","#SC",$input);
    $input = str_replace(")","#CB",$input);
    $input = str_replace("\n","#NL",$input);
    $input = str_replace("\r","#CR",$input);
    return $input;
}

function decode_for_sql($input) {
    $input = str_replace("#SQ","'",$input);
    $input = str_replace("#DQ","\"",$input);
    $input = str_replace("#SC",";",$input);
    $input = str_replace("#CB",")",$input);
    $input = str_replace("#NL","\n",$input);
    $input = str_replace("#CR","\r",$input);
    return $input;
}

function tvconv($iv) {
    if ($iv == "1") {
        return true;
    } elseif ($iv == "0") {
        return false;
    }
    if (is_numeric($iv)) {
        if (str_contains($iv,".")) {
            return (float)$iv;
        }
        return (int)$iv;
    } else {
        return $iv;
    }
}

function run_query($qs) {
    //echo $qs;
    //Returns list of dicts or null if error.
    global $sql_loc;
    global $sql_db;
    global $sql_user;
    global $sql_password;

    $c = new mysqli(
        $sql_loc,
        $sql_user,
        $sql_password,
        $sql_db
    );
    //$c->connect();
    
    $result = $c->query($qs);
    $final = array();
    if (is_bool($result)) {
        return array();
    }
    if ($result->num_rows > 0) {
        // output data of each row
        while($row = $result->fetch_assoc()) {
            //array_push($final,$row);
            $t = array();
            foreach ($row as $key => $value) {
                $nv = tvconv($value);
                //echo $key . " : " . $nv. " : " . gettype($nv) . "\n";
                //For some reason, it isn't preserving the types
                $t[$key] = $nv;
            }
            array_push($final,$t);
        }
    } else {
        $final = array();
    }

    $c->close();
    return $final;

}

function run_query_p($query) {
    $final = array();
    foreach ($query as $st) {
        //echo $st;
        $final = array_merge($final,run_query($st));
    }
    return $final;
}

function run_non_query_p($query) {
    $iserror = false;
    foreach ($query as $st) {
        
        if (!run_non_query($st)) {
            $iserror = true;
            break;
        }
    }
    return $iserror;
}

function GetDirectorySize($path){
    $bytestotal = 0;
    $path = realpath($path);
    if($path!==false && $path!='' && file_exists($path)){
        foreach(new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path, FilesystemIterator::SKIP_DOTS)) as $object){
            $bytestotal += $object->getSize();
        }
    }
    return $bytestotal;
}

header("content-type: application/json");

try {
    $fd = json_decode(file_get_contents("db.json"),true);

    $sql_loc = $fd['location'];
    $sql_db = $fd['dbname'];
    $sql_user = $fd['sqluser'];
    $sql_password = $fd['sqlpass'];
    $sql_port = $fd['port'];

    
    $body = json_decode(file_get_contents('php://input'),true);
    $username = $body["_username"];
    $password = $body["_password"];
    $is_valid_password = count(run_query("select * from accounts where username = '" . encode_for_sql($username) . "' and password = SHA2('" . encode_for_sql($password) . "',256) and isactive = true")) > 0 ;
    if (!$is_valid_password) {
        error(401,"Invalid account");
    }

    //Check if user has enough privilege
    $priv = run_query("select privilege from accounts where username = '" . encode_for_sql($username) . "'")[0]["privilege"];
    if ($priv < 3) {
        //Less than admin
        error(403,"Insufficient Privilege");
    }
    
    $action = $body["_action"];

    if ($action == "getinfo") {
        $fdir = realpath("../files/");
        $freepsace = disk_free_space($fdir);
        $usedspace = disk_total_space($fdir) - $freepsace;
        $total = disk_total_space($fdir);
        senddata(["free" => $freepsace,"used" => $usedspace, "total" => $total]);
    }
    if ($action == "fileinfo") {
        $fdir = realpath("../files/");
        $tsize = GetDirectorySize($fdir);//Copied from SO
        $fcount = count(glob("../files/*.*"));
        senddata(["size" => $tsize,"count" => $fcount]);
    }

    error(400,"Invalid Request.");
    exit(1);
} catch (Exception $e) {
    error(500,$e->getMessage() . "\n" . $e->getTraceAsString());
    exit(1);
}